#include <fcgiapp.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <errno.h>
#include "main.h"
#include "utils.h"

extern struct stconfig config;
extern int srcline;
extern FCGX_Request request;


char* lprintf(char s[], va_list ap){
	va_list ap2;
	char *buf;
	int len;

	va_copy(ap2, ap);

	len = vsnprintf(NULL, 0, s, ap);
	buf = malloc(len + 1);

	vsprintf(buf, s, ap2);
	va_end(ap2);
	return buf;

}


char *lsprintf(char s[], ...){
	va_list ap;
	size_t len;
	char *buf;

	va_start(ap, s);
	len = vsnprintf(NULL, 0, s, ap);
	va_end(ap);
	buf = malloc(len + 1);
	va_start(ap, s);
	vsprintf(buf, s, ap);
	va_end(ap);
	return buf;
}





char* cleanquery(const char q[]){
	const size_t len = strlen(q);
	char *ret = NULL;
	unsigned j;
	// first run -> compute size, second, copy
	for(unsigned run = 0; run < 2; run++){
		unsigned inquotes = 0;
		j = 0;
		for(unsigned i = 0; i < len; i++){
			if(q[i] == '\'' && i != 1 && q[i - 1] != '\\') inquotes = 1 - inquotes;
			if(!inquotes && (((q[i] == ' ' || q[i] == '\t') && (i == 1 || q[i - 1] == ' ' || q[i - 1] == '\t')) ||
				q[i] == '\n')) continue;

			if(run != 0) ret[j] = q[i] == '\t' ? ' ' : q[i];
			j++;
		}
		if(run == 0) ret = malloc(j + 1);
	}
	ret[j] = '\0';
	return ret;
}

/******************************************************************************
 *
 * strtold() commodity
 * returns NAN on error, the conversion on success
 ****************************************************************************/

long double mystrtold(const char * const string){
	if(string == NULL) return NAN;
	char *end;
	long double ret = strtold(string, &end);
	return end == string || *end != '\0' || errno == ERANGE ? NAN : ret;
}

/******************************************************************************
 *
 * printf for stderr
 *
 *****************************************************************************/


void errout(char s[], ...){
	va_list ap;

	va_start(ap, s);
	if(config.socketpath) FCGX_VFPrintF(request.err, s, ap);
	else vfprintf(stderr, s, ap);

	va_end(ap);
}
/******************************************************************************
 *
 * printf for stderr, appends source line number and flush output
 *
 *****************************************************************************/


void errprint(char s[], ...){
	va_list ap;

	va_start(ap, s);
	if(config.socketpath){
		FCGX_VFPrintF(request.err, s, ap);
		FCGX_FPrintF(request.err, " line %d", srcline);
	}
	else{
		vfprintf(stderr, s, ap);
		fprintf(stderr, " line %d", srcline);
	}
	va_end(ap);

	terminatestderr();
}

/******************************************************************************
 *
 * adds CR if stderr == 2, fflush otherwise (apache log)
 *
 *****************************************************************************/
void terminatestderr(void){
	if(config.socketpath) FCGX_FFlush(request.err); // flush line for apache
	else fputc('\n', stderr);

}

