#ifndef __LSQL_H
#define __LSQL_H

#include <mysql/mysql.h>
#include "blang.h"

typedef struct stqret{
	unsigned c;
	char **names;
	size_t *namelens;
	char *isnum;
} *QRET;

struct morebindfields{
	unsigned long length;
	bool error;
	bool is_null;
};

typedef struct stcachedquery{
	MYSQL_STMT *stmt;
	char *query;
	MYSQL_BIND *inbinds;
	unsigned long *inlengths;
	unsigned fieldcount;
	struct stcachedquery *next;
	struct stcachedquery *prev;
} *CACHEDQUERY;



int db_connect(int);
void db_disconnect(void);
int setautocommit(bool);
ht* vquery(char[], char*[], size_t, int*);
void freequeryresult(QRET);
void freequerylist(void);

#endif
