#include <stdlib.h>
#include <string.h>
#include "lstring.h"


static inline void expandbuffer(struct string * const, const size_t);

struct string* newlstring(){
	struct string* ret = malloc(sizeof(struct string));
	ret->buffersize = LSTRING_INITIAL_BUFFER;
	ret->buffer = malloc(ret->buffersize);
	ret->length = 0;
	return ret;
}



struct string* tolstring(const char src[]){
	struct string *ret = malloc(sizeof(struct string));
	ret->length = strlen(src);
	ret->buffersize = ret->length + 1;
	ret->buffer = malloc(ret->buffersize);
	memcpy(ret->buffer, src, ret->length);
	return ret;
}


void lstringappend(struct string * const dst, const char src[]){
	size_t length = strlen(src);
	expandbuffer(dst, length);
	memcpy(dst->buffer + dst->length, src, length);
	dst->length += length;
}

void lstringappendc(struct string * const dst, const char src){
	expandbuffer(dst, 1);
	dst->buffer[dst->length] = src;
	dst->length++;
}


void lstringassign(struct string * const dst, const char src[]){
	dst->length = strlen(src);
	dst->buffersize = dst->length + 1;
	dst->buffer = realloc(dst->buffer, dst->buffersize);
	memcpy(dst->buffer, src, dst->length);
}

void freelstring(struct string *str){
	free(str->buffer);
	free(str);
}


char* lstringbuffer(const struct string * const str){
	str->buffer[str->length] = '\0';
	return str->buffer;
}


static inline void expandbuffer(struct string * const str, const size_t addedlength){
	while(str->length + addedlength >= str->buffersize)
		str->buffersize *= 2; // did you know? compilers already translates this to << 1
	str->buffer = realloc(str->buffer, str->buffersize);
}