%{
#include "lang.h"



%}

%option noyywrap
%option noinput
%option nounput
%option yylineno

digit         [0-9]
alpha         [a-zA-Z_]
alnum         [{alpha}0-9]
bool          (?i:true)|(?i:false)
ldbl          {digit}+(\.{digit}+)?
identifier    {alpha}+{alnum}*
string        \"([^"\\]*)(\\.[^"\\]*)*\"
blanks        [ \t\n\r]+|\/\/.*\n|"/*"([^*]|\*+[^*/])*\*+"/"
post          \${alpha}+{alnum}*


%%

{bool}         {yylval.ubool = strcasecmp(yytext, "true") ? 0 : 1; return BOOL;}
"undefined"    {return UNDEFINED;}
"return"       {return RETURN;}
":"            {return COLON;}
"if"           {return IF;}
"fi"           {return FI;}
"else"         {return ELSE;}
"while"        {return WHILE;}
"wend"         {return WEND;}
"sql"          {return SQL;}
"millis"       {return MILLIS;}
"upper"        {return UPPER;}
"lower"        {return LOWER;}
"substr"       {return SUBSTR;}
"debug"        {return TOSTDERR;}
"log"          {return LOG;}
"("            {return PARENL;}
")"            {return PARENR;}
"{"            {return CURLYL;}
"}"            {return CURLYR;}
"["            {return BRACKETL;}
"]"            {return BRACKETR;}
{blanks}       {}
","            {return COMMA;}
{post}         {yylval.str = strdup(yytext + 1); return POST;}
{identifier}   {yylval.str = strdup(yytext); return IDENTIFIER;}
{string}       {
	size_t len = strlen(yytext) - 2;
	yylval.str = malloc(len + 1);
	memcpy(yylval.str, yytext + 1, len);
	yylval.str[len] = '\0';
	return STRING;
}
{ldbl}         {yylval.ldbl = strtold(yytext, NULL); return LDOUBLE;}
"=="           {return DOUBLEEQUAL;}
">="           {return SUPEQ;}
"<="           {return INFEQ;}
">"            {return SUP;}
"<"            {return INF;}
"!="           {return NOTEQUAL;}
"="            {return EQUAL;}
"-"            {return MINUS;}
"+"            {return PLUS;}
"*"            {return MUL;}
"/"            {return DIV;}
"||"           {return LOR;}
"&&"           {return LAND;}
"!"            {return NOT;}
. return yytext[0];

