#ifndef __LBLANG_H
#define __LBLANG_H

#include <stdbool.h>
#include "params.h"
#include "hash.h"




typedef struct stvalue *VAL;
typedef struct hashtable ht;
typedef struct hashtable_entry ht_entry;
typedef struct hashtable_iterator hti;


enum opcode{
	IEXECQ,
	IDEBUG,
	IMILLIS,
	IUPPER,
	ILOWER,
	ISUBSTR,
	IARR,
	IASSIGNARR,
	IJZ,
	IJMP,
	IRETURN,
	IASSIGN,
	IPUSH,
	IEQUALS,
	INEQUALS,
	ISUPEQ,
	ISUP,
	IINFEQ,
	IINF,
	IADD,
	ISUB,
	IMUL,
	IDIV,
	ILOR,
	ILAND,
	INOT,
	INEG,
	IPOST,
	IEND // THIS ONE IS DECEPTIVE: actually used as a placeholder for branches
	     // management in bison
	     // (when we have to jump to an instruction which has not yet been created)
	     // (or to jump at end of program)
};




enum val{
	VUNDEF = 0, // keep it first
	VSTRING,
	VLDOUBLE,
	VBOOL,
	VARRAY,
	VJSONARRAY,
	VJSONOBJECT
};

struct stvalue{
	enum val type;
	union{
		char *strval;
		bool boolval;
		long double ldblval;
		struct{
			size_t jsonsize;
			struct stvalue *results;
		}jsonval;
		ht *hash;
	};
};

struct hashtable {
	ht_entry* entries;
	size_t capacity;
	size_t mincapacity;
	size_t length;
	ht_entry *lastentry;
};


typedef struct hashtable_entry {
	char key[MAX_KEY_LENGTH];
	size_t keylen;
	uint64_t hash;
	int filled;
	struct stvalue value; // keep it last of struct, used by offsetof
} ht_entry;

typedef struct hashtable_iterator{
	ht *table;
	ht_entry *current;
	struct stvalue *value;
	char *key;
} hti;


struct steval{
	struct stblock *block;
	VAL value;
};

typedef struct var{
	VAL val;
	char *name;
	struct var *next;
} *VAR;

typedef struct post{
	char *name;
	struct var *next;
} *POSTNAME;


typedef struct stinstruction{
	enum opcode op;
	int srcline;
	struct stinstruction *next;
	union{
		size_t pop;
		struct{
			VAL op1;
			VAL op2;
		}opds;
		VAL pushval;
		struct{
			VAL testval;
			struct stinstruction *jmpto;
		}jump;
		char *postname;
		struct{
			VAL array;
			size_t pop;
		}array;
	};
} *INSTR;


struct stblock{
	size_t nbparams;
	INSTR first;
	INSTR last;
};
#endif
