
#ifndef LLHASH
#define LLHASH

#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>
#include "blang.h"



typedef struct stvalue *VAL;
typedef struct hashtable ht;
typedef struct hashtable_entry ht_entry;
typedef struct hashtable_iterator hti;



ht* ht_create(const size_t);
void ht_destroy(ht* const restrict);
void* ht_set(ht* const restrict, const void * const restrict, const size_t, const struct stvalue* const restrict);
VAL ht_get(ht* const restrict, const void * const restrict, const size_t, const struct stvalue * const restrict);
int ht_unset(ht* const restrict, const char* const restrict, const size_t);
hti* hti_create(ht * const restrict);
void hti_next(hti * const restrict);
void hti_reset(hti * const restrict);

#endif
