#include <stdio.h>
#include <pthread.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

static unsigned highgovernortime;
static pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
static int ismanaged;
static void* managegovernor(void*);
static unsigned relapsetime;
static const char *slowgov;
static const char *fastgov;
static pthread_t thread;

static const char GOVERNORNAME[] = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor";

int gouptime(){
	if(ismanaged == 0) return 0;
	pthread_mutex_lock(&mutex);
	if(highgovernortime == 0){
		FILE *f = fopen(GOVERNORNAME, "w");
		fputs(fastgov, f);
		fclose(f);
	}
	highgovernortime = relapsetime + 1;
	pthread_mutex_unlock(&mutex);
	return 0;
}

int initgovernor(const unsigned delaytime, const char lowgov[], const char highgov[]){
	if(delaytime <= 1 || access(GOVERNORNAME, F_OK) != 0){
		ismanaged = 0;
		return 0;
	}
	relapsetime = delaytime;
	slowgov = lowgov;
	fastgov = highgov;
	ismanaged = 1;
	pthread_create(&thread, NULL, managegovernor, NULL);
	return 0;
}




static void* managegovernor(void* useless){
	while(1){
		if(highgovernortime != 0){
			pthread_mutex_lock(&mutex);
			if(highgovernortime == 1){
				FILE *f = fopen(GOVERNORNAME, "w");
				fputs(slowgov, f);
				fclose(f);
			}
			highgovernortime--;
			pthread_mutex_unlock(&mutex);
		}
		sleep(1);
	}
	return NULL;
}


void stopgovernor(int useless){
	void *retval;

	if(ismanaged == 0) exit(0);

	highgovernortime = 100000;
	pthread_mutex_lock(&mutex);
	pthread_cancel(thread);
	pthread_join(thread, &retval);
	FILE *f = fopen(GOVERNORNAME, "w");
	fputs(slowgov, f);
	fclose(f);
	pthread_mutex_unlock(&mutex);
	exit(0);
}