
#ifndef LLHASH
#define LLHASH

#include <stdlib.h>
#include <stdint.h>


#define MAX_KEY_LENGTH 32

typedef struct {
	char key[MAX_KEY_LENGTH];
	uint64_t hash;
	uint8_t value[];
} ht_entry;



typedef struct{
	ht_entry* entries;
	size_t capacity;
	size_t mincapacity;
	size_t length;
	size_t valuesize;
	size_t entrysize;
	ht_entry *lastentry;
} ht;

typedef struct{
	ht *table;
	ht_entry *current;
	void *value;
	char *key;
} hti;



ht* ht_create(const size_t, const size_t);
void ht_destroy(ht* const restrict);
void* ht_set(ht* const restrict, const char * const restrict, const void* const restrict);
void* ht_get(ht* const restrict, const char * const restrict, const void * const restrict);
int ht_unset(ht* const restrict, const char* const restrict);
hti* hti_create(ht * const restrict);
void hti_next(hti * const restrict);
void hti_reset(hti * const restrict);

#endif
